//
//  ViewController.m
//  PrinterDemo
//
//  Created by Apple Mac mini intel on 2024/4/20.
//

#import "ViewController.h"
#import "XSDKPrinter.h"
#import "UIView+Toast.h"
#import "TSPLPrinterVC.h"
#import "POSPrinterVC.h"
#import "ZPLPrinterVC.h"
#import "CPCLPrinterVC.h"
@interface ViewController ()<XBLEManagerDelegate, XWIFIManagerDelegate>
@property (assign, nonatomic) ConnectType connectType;
@property (weak, nonatomic) IBOutlet UIButton *disconnectButton;
@property (weak, nonatomic) IBOutlet UILabel *netLabel;
@property (weak, nonatomic) IBOutlet UITextField *netTextField;
@property (weak, nonatomic) IBOutlet UIButton *bleSelectButton;
@property (strong, nonatomic) XBLEManager *bleManager;
@property (strong, nonatomic) XWIFIManager *wifiManager;
@property (weak, nonatomic) IBOutlet UIButton *debugButton;
@property (weak, nonatomic) IBOutlet UIButton *connectNetButton;
@property (weak, nonatomic) IBOutlet UIButton *tsplButton;
@property (weak, nonatomic) IBOutlet UIButton *posButton;
@property (weak, nonatomic) IBOutlet UIButton *zplButton;
@property (weak, nonatomic) IBOutlet UIButton *cpclButton;
@property (weak, nonatomic) IBOutlet UIButton *customButton;
@property (weak, nonatomic) IBOutlet UIButton *rfidButton;

@end

@implementation ViewController

- (void)buttonStateOn {
    _disconnectButton.enabled = YES;
    _debugButton.enabled = YES;
    _tsplButton.enabled = YES;
    _posButton.enabled = YES;
    _zplButton.enabled = YES;
    _cpclButton.enabled = YES;
    _customButton.enabled = YES;
    _rfidButton.enabled = YES;
}

- (void)buttonStateOff {
    _disconnectButton.enabled = NO;
    _debugButton.enabled = NO;
    _tsplButton.enabled = NO;
    _posButton.enabled = NO;
    _zplButton.enabled = NO;
    _cpclButton.enabled = NO;
    _customButton.enabled = NO;
    _rfidButton.enabled = NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"Home";
    _bleManager = [XBLEManager sharedInstance];
    _bleManager.delegate = self;
    _wifiManager = [XWIFIManager sharedInstance];
    _wifiManager.delegate = self;
    [self buttonStateOff];
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(keyboardDismiss)];
    self.view.userInteractionEnabled = YES;
    [self.view addGestureRecognizer:tap];
}

- (void)dealloc {
    [_bleManager removeDelegate:self];
}

- (IBAction)switchConnectMethodAction:(UISegmentedControl *)sender {
    _netLabel.hidden = (sender.selectedSegmentIndex == 0)?YES:NO;
    _connectNetButton.hidden = (sender.selectedSegmentIndex == 0)?YES:NO;
    _netTextField.hidden = (sender.selectedSegmentIndex == 0)?YES:NO;
    _bleSelectButton.hidden = (sender.selectedSegmentIndex == 0)?NO:YES;
    [self.debugButton setTitle:(sender.selectedSegmentIndex == 0)?@"BLE TEST":@"NET TEST" forState:UIControlStateNormal];
    if (sender.selectedSegmentIndex == 0) {
        _connectType = ConnectTypeBluetooth;
    } else {
        _connectType = ConnectTypeWiFi;
    }
}


- (IBAction)connectAction:(UIButton *)sender {
    if (self.netTextField.text.length == 0) {
        [self.view makeToast:@"please input net address" duration:1.f position:CSToastPositionCenter];
    }
    
    if (_wifiManager.isConnected) {
        [_wifiManager disconnect];
    }
    
    [self keyboardDismiss];
    [_wifiManager connectWithHost:self.netTextField.text port:9100];
}

- (IBAction)disconnectAtion:(UIButton *)sender {
    
    if (_connectType == ConnectTypeBluetooth) {
        [_bleManager disconnectRootPeripheral];
    } else if (_connectType == ConnectTypeWiFi) {
        [_wifiManager disconnect];
    }
}

- (void)keyboardDismiss {
    [self.netTextField resignFirstResponder];
}

#pragma mark - MBLEManagerDelegate

- (void)xbleConnectPeripheral:(CBPeripheral *)peripheral {
    _connectType = ConnectTypeBluetooth;
    [_bleSelectButton setTitle:peripheral.name forState:UIControlStateNormal];
    [self.view makeToast:@"connect success." duration:1.f position:CSToastPositionCenter];
    [self buttonStateOn];
}

- (void)xbleDisconnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error {

    if (_wifiManager.isConnected) {
        _connectType = ConnectTypeWiFi;
    } else {
        [self.view makeToast:@"disconnect." duration:1.f position:CSToastPositionCenter];
        _connectType = ConnectTypeNone;
        [_bleSelectButton setTitle:@"Scan Bluetooth" forState:UIControlStateNormal];
        [self buttonStateOff];
    }
}

#pragma mark - MWIFIManagerDelegate

- (void)xWifiConnectedToHost:(NSString *)host port:(UInt16)port {
    _connectType = ConnectTypeWiFi;
    [self.view makeToast:@"connect success." duration:1.f position:CSToastPositionCenter];
    [self buttonStateOn];
    [_wifiManager printerPOSStatus:^(NSData *status) {
        [self toastWith:status];
    }];
    
}

- (void)xWifiDisconnectWithError:(NSError *)error {
    if (_bleManager.isConnected) {
        _connectType = ConnectTypeBluetooth;
    } else {
        [self.view makeToast:@"disconnect." duration:1.f position:CSToastPositionCenter];
        _connectType = ConnectTypeNone;
        [self buttonStateOff];
    }
    
    if (error) {
        [self.view makeToast:[NSString stringWithFormat:@"%@", error] duration:2.f position:CSToastPositionCenter];
    }
}

- (void)toastWith:(NSData *)data {

    unsigned status = 0;
    if (data.length == 1) {
        const Byte *byte = (Byte *)[data bytes];
        status = byte[0];
    } else if (data.length == 2) {
        const Byte *byte = (Byte *)[data bytes];
        status = byte[1];
    }
    
    if (status == 0x00) {
        [self.view makeToast:@"Ready" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x01) {
        [self.view makeToast:@"Cover opened" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x02) {
        [self.view makeToast:@"Paper jam" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x03) {
        [self.view makeToast:@"Cover opened and paper jam" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x04) {
        [self.view makeToast:@"Paper end" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x05) {
        [self.view makeToast:@"Cover opened and Paper end" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x08) {
        [self.view makeToast:@"No Ribbon" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x09) {
        [self.view makeToast:@"Cover opened and no Ribbon" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x10) {
        [self.view makeToast:@"Pause" duration:1.f position:CSToastPositionCenter];
    } else if (status == 0x20) {
        [self.view makeToast:@"Printing.." duration:1.f position:CSToastPositionCenter];
    }
}

- (IBSegueAction TSPLPrinterVC *)tsplPrinterVC:(NSCoder *)coder sender:(id)sender segueIdentifier:(NSString *)segueIdentifier {
    TSPLPrinterVC *tsplVc = [[TSPLPrinterVC alloc] initWithCoder:coder];
    tsplVc.connectType = (int)self.connectType;
    return tsplVc;
}

- (IBSegueAction POSPrinterVC *)posPrinterVC:(NSCoder *)coder sender:(id)sender segueIdentifier:(NSString *)segueIdentifier {
    POSPrinterVC *posVc = [[POSPrinterVC alloc] initWithCoder:coder];
    posVc.connectType = (int)self.connectType;
    return posVc;
}
- (IBSegueAction ZPLPrinterVC *)zplPrinterVC:(NSCoder *)coder sender:(id)sender segueIdentifier:(NSString *)segueIdentifier {
    ZPLPrinterVC *zplVc = [[ZPLPrinterVC alloc] initWithCoder:coder];
    zplVc.connectType = (int)self.connectType;
    return zplVc;
}

- (IBSegueAction CPCLPrinterVC *)cpclPrinterVC:(NSCoder *)coder sender:(id)sender segueIdentifier:(NSString *)segueIdentifier {
    CPCLPrinterVC *cpclVc = [[CPCLPrinterVC alloc] initWithCoder:coder];
    cpclVc.connectType = (int)self.connectType;
    return cpclVc;
}


@end
